/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.textmc;

import com.mojang.blaze3d.systems.RenderSystem;
import icyllis.annotations.NotNull;
import icyllis.modernui.core.mixin.AccessFontRenderer;
import icyllis.modernui.graphics.textmc.ModernStringSplitter;
import icyllis.modernui.graphics.textmc.TextLayoutProcessor;
import icyllis.modernui.graphics.textmc.pipeline.TextRenderNode;
import icyllis.modernui.platform.RenderCore;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.fonts.Font;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.CharacterManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableFloat;

@OnlyIn(value=Dist.CLIENT)
public class ModernFontRenderer
extends FontRenderer {
    private static ModernFontRenderer instance;
    private boolean allowShadow = true;
    private boolean mGlobalRenderer = false;
    private final TextLayoutProcessor mFontEngine = TextLayoutProcessor.getInstance();
    private final MutableFloat v = new MutableFloat();
    private ModernStringSplitter modernStringSplitter;
    private CharacterManager vanillaStringSplitter;

    private ModernFontRenderer(Function<ResourceLocation, Font> fonts) {
        super(fonts);
    }

    public static FontRenderer create(Function<ResourceLocation, Font> fonts) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (instance == null) {
            ModernFontRenderer i = new ModernFontRenderer(fonts);
            CharacterManager o = i.func_238420_b_();
            CharacterManager.ICharWidthProvider c = (codePoint, style) -> i.mFontEngine.lookupVanillaNode((CharSequence)new String((int[])new int[]{codePoint}, (int)0, (int)1), (Style)style).advance;
            i.modernStringSplitter = new ModernStringSplitter(c);
            i.vanillaStringSplitter = o;
            instance = i;
            return instance;
        }
        throw new IllegalStateException("Already created");
    }

    public static void change(boolean global, boolean shadow) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (RenderCore.isInitialized()) {
            if (ModernFontRenderer.instance.mGlobalRenderer != global) {
                ((AccessFontRenderer)((Object)instance)).setSplitter(global ? ModernFontRenderer.instance.modernStringSplitter : ModernFontRenderer.instance.vanillaStringSplitter);
                ModernFontRenderer.instance.mGlobalRenderer = global;
            }
            ModernFontRenderer.instance.allowShadow = shadow;
        }
    }

    public static boolean isGlobalRenderer() {
        return ModernFontRenderer.instance.mGlobalRenderer;
    }

    public int func_238411_a_(@Nonnull String text, float x, float y, int color, boolean dropShadow, @NotNull Matrix4f matrix, @Nonnull IRenderTypeBuffer buffer, boolean seeThrough, int colorBackground, int packedLight, boolean bidiFlag) {
        if (this.mGlobalRenderer) {
            x += this.drawLayer0(text, x, y, color, dropShadow, matrix, buffer, seeThrough, colorBackground, packedLight, Style.field_240709_b_);
            return (int)x + (dropShadow ? 1 : 0);
        }
        return super.func_238411_a_(text, x, y, color, dropShadow, matrix, buffer, seeThrough, colorBackground, packedLight, bidiFlag);
    }

    public int func_243247_a(@Nonnull ITextComponent text, float x, float y, int color, boolean dropShadow, @Nonnull Matrix4f matrix, @Nonnull IRenderTypeBuffer buffer, boolean seeThrough, int colorBackground, int packedLight) {
        if (this.mGlobalRenderer) {
            this.v.setValue(x);
            text.func_230439_a_((style, t) -> {
                this.v.add(this.drawLayer0(t, this.v.floatValue(), y, color, dropShadow, matrix, buffer, seeThrough, colorBackground, packedLight, style));
                return Optional.empty();
            }, Style.field_240709_b_);
            return this.v.intValue() + (dropShadow ? 1 : 0);
        }
        return super.func_243247_a(text, x, y, color, dropShadow, matrix, buffer, seeThrough, colorBackground, packedLight);
    }

    public void drawText(@Nonnull ITextProperties text, float x, float y, int color, boolean dropShadow, @Nonnull Matrix4f matrix, @Nonnull IRenderTypeBuffer buffer, boolean seeThrough, int colorBackground, int packedLight) {
        if (this.mGlobalRenderer) {
            this.v.setValue(x);
            text.func_230439_a_((style, t) -> {
                this.v.add(this.drawLayer0(t, this.v.floatValue(), y, color, dropShadow, matrix, buffer, seeThrough, colorBackground, packedLight, style));
                return Optional.empty();
            }, Style.field_240709_b_);
        } else {
            super.func_238416_a_(LanguageMap.func_74808_a().func_241870_a(text), x, y, color, dropShadow, matrix, buffer, seeThrough, colorBackground, packedLight);
        }
    }

    public int func_238416_a_(@Nonnull IReorderingProcessor text, float x, float y, int color, boolean dropShadow, @Nonnull Matrix4f matrix, @Nonnull IRenderTypeBuffer buffer, boolean seeThrough, int colorBackground, int packedLight) {
        if (this.mGlobalRenderer && text.accept((index, style, codePoint) -> style.func_240729_k_() != Minecraft.field_71464_q)) {
            this.v.setValue(x);
            this.mFontEngine.handleSequence(text, (t, style) -> {
                this.v.add(this.drawLayer0(t, this.v.floatValue(), y, color, dropShadow, matrix, buffer, seeThrough, colorBackground, packedLight, style));
                return false;
            });
            return this.v.intValue() + (dropShadow ? 1 : 0);
        }
        return super.func_238416_a_(text, x, y, color, dropShadow, matrix, buffer, seeThrough, colorBackground, packedLight);
    }

    private float drawLayer0(@Nonnull CharSequence text, float x, float y, int color, boolean dropShadow, Matrix4f matrix, @Nonnull IRenderTypeBuffer buffer, boolean seeThrough, int colorBackground, int packedLight, Style style) {
        if (text.length() == 0) {
            return 0.0f;
        }
        if ((color & 0xFE000000) == 0) {
            color |= 0xFF000000;
        }
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g2 = color >> 8 & 0xFF;
        int b = color & 0xFF;
        TextRenderNode node = this.mFontEngine.lookupVanillaNode(text, style);
        if (dropShadow && this.allowShadow) {
            node.drawText(matrix, buffer, text, x + 0.8f, y + 0.8f, r >> 2, g2 >> 2, b >> 2, a, true, seeThrough, colorBackground, packedLight);
            matrix = matrix.func_226601_d_();
            matrix.func_226597_a_(AccessFontRenderer.shadowLifting());
        }
        return node.drawText(matrix, buffer, text, x, y, r, g2, b, a, false, seeThrough, colorBackground, packedLight);
    }

    @Deprecated
    @Nonnull
    public String func_147647_b(@Nonnull String text) {
        if (this.mGlobalRenderer) {
            return text;
        }
        return super.func_147647_b(text);
    }
}

